local t = Def.ActorFrame {Name = "SpeedistLuaFile",}

local function getPlayerOptionPreferred(funcname)
    local poptions = GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptions("ModsLevel_Preferred")
    return poptions[funcname](poptions)
end

local function getOriginalBGBrightness()
    return PREFSMAN:GetPreference("BGBrightness")
end

local function setBGBrightness(value)
	PREFSMAN:SetPreference("BGBrightness", value)
end

t[#t+1] = Def.Actor {
    Name = "Speedist",
    InitCommand = function(self)
        self.xmodValue = getPlayerOptionPreferred("XMod")
        self.cmodValue = getPlayerOptionPreferred("CMod")
        self.mmodValue = getPlayerOptionPreferred("MMod")


		originalBGBrightness = getOriginalBGBrightness()
		if originalBGBrightness < (1) then
			setBGBrightness(1)
		end

        self:sleep(99999)
    end,
    EndCommand = function(self)
        setBGBrightness(originalBGBrightness)
    end
}

return t
